#include "LCD12864.h"

//read LCD busy flag, if flag=1, LCD is busy, have to wait; 
//otherwise (0) it is free for write command/data
bit LCD_Busy()
{                          
    bit result;

    LCD_RS = 0;
    LCD_RW = 1;
    LCD_EN = 1;
    _nop_();
	_nop_();
	_nop_();
	_nop_();
    result = (bit)(P0&0x80);
    LCD_EN = 0;

    return(result); 
}

/*******************************************************************/
/*                                                                 */
/*Write Command to LCD                                             */
/*RS=L, RW=L, E=L->H->L high pulse, D0-D7=Command                  */
/*                                                                 */
/*******************************************************************/
void LCD_Write_Command(Byte cmd)
{                          
	while(LCD_Busy());

    LCD_RS = 0;
    LCD_RW = 0;
    LCD_EN = 0;
    _nop_();
    _nop_();    
	LCD_data = cmd;
    _nop_();
	_nop_();
	_nop_();
	_nop_();

    LCD_EN = 1;
    _nop_();
	_nop_();
	_nop_();
	_nop_();
    LCD_EN = 0;  
}

/*******************************************************************/
/*                                                                 */
/*Write Data to LCD                                                */
/*RS=H, RW=L, E=L->H->L high pulse, D0-D7=Command                  */
/*                                                                 */
/*******************************************************************/
void LCD_Write_Data(Byte dat)
{                          
   while(LCD_Busy());

    LCD_RS = 1;
    LCD_RW = 0;
    LCD_EN = 0;
    LCD_data = dat;
    _nop_();
	_nop_();
	_nop_();
	_nop_();
    LCD_EN = 1;
    _nop_();
	_nop_();
	_nop_();
	_nop_();
    LCD_EN = 0; 
}
/*******************************************************************/
/*                                                                 */
/*  LCD Initialize                                                 */
/*                                                                 */
/*******************************************************************/
void LCD_Init()
{ 

    LCD_PSB = 1;         			//Select Parallel 	
    
    LCD_Write_Command(0x34);      	//Extended instruction
    delayXms(100);
    LCD_Write_Command(0x30);      	//Basic instruction
    delayXms(100);
    LCD_Write_Command(0x0C);      	//Display on, cursor off
    delayXms(100);
    LCD_Write_Command(0x01);      	//Clear LCD
    delayXms(100);
}

void LCD_Set_Position(Byte line, Byte col)
{                          
   	Byte  pos;

   	if (line == 0)
     	line = 0x80;
   	else if (line == 1)
   		line =0x90;
   	else if (line == 2)
     	line = 0x88;
   	else if (line == 3)
     	line = 0x98;

   	pos = line + col ;  
   	LCD_Write_Command(pos);     //Set DDRAM Address
}

void LCD_Write_String(Byte line, Byte col, Byte *s) {
	
	LCD_Set_Position(line, col);
    
    while(*s != '\0')
    {                         //ʾַ
       LCD_Write_Data(*s);
       s++;
    }
}

/*******************************************
Draw Picture
********************************************/
void Draw_PM(const Byte *ptr)
{
    Byte i,j,k;
     
	LCD_Write_Command(0x34);        //use extended instruction
	i = 0x80;            
	for(j = 0;j < 32;j++)
	{
        LCD_Write_Command(i++);
        LCD_Write_Command(0x80);
  		for(k = 0;k < 16;k++)
  		{
  		    LCD_Write_Data(*ptr++);
  		}
	}
	i = 0x80;
 	for(j = 0;j < 32;j++)
	{
 	    LCD_Write_Command(i++);
        LCD_Write_Command(0x88);	   
  		for(k = 0;k < 16;k++)
  		{
   		    LCD_Write_Data(*ptr++);
   		} 
	}  
    LCD_Write_Command(0x36);        //turn on graphic display
	LCD_Write_Command(0x30);        //back to basic instruction
}

//========================================================
//address set,0 <= x < 8,0 <= y < 128
//========================================================
void LCD128X64Addr(Byte x,Byte y)
{
	Byte row,colh,coll;

	row = x | 0xb0;
	colh = (y >> 4) | 0x10;
	coll = y & 0x0f;
	LCD_Write_Command(row);
	LCD_Write_Command(colh);
	LCD_Write_Command(coll);

}
void DispGraph(Byte x,Byte y,Byte w,Byte h,Byte *ch)
{
	Byte i,j;
	for(i = 0;i < h / 8;i ++)
	{
		LCD128X64Addr(7 - x - i,y);
		for(j = 0;j < w;j ++)
		{
			LCD_Write_Data(*ch);
			ch ++;
		}
	}
}